<?php
error_reporting(E_ALL);

/* ================= CONFIG ================= */
$dataFile = __DIR__ . '/data.csv';
$template = __DIR__ . '/template_1920x1080.jpg';

$fontBold = __DIR__ . '/fonts/Roboto-Bold.ttf';
$fontReg  = __DIR__ . '/fonts/Roboto-Regular.ttf';

$row = isset($_GET['row']) ? (int)$_GET['row'] : 0;
$mode = isset($batchFile) ? 'batch' : 'preview';

/* ================= LOAD CSV ================= */
$rows = [];
if (($h = fopen($dataFile, 'r')) !== false) {
    while (($c = fgetcsv($h, 0, ',')) !== false) {
        if (count($c) < 6) continue;
        $rows[] = array_map('trim', $c);
    }
    fclose($h);
}
if (!isset($rows[$row])) exit('ROW NOT FOUND');

/* ================= MAP CSV ================= */
$rawTitle = $rows[$row][0];
$subTitle = $rows[$row][1];
$location = $rows[$row][2];
$caption  = $rows[$row][3];
$leftBot  = $rows[$row][4];
$rightBot = $rows[$row][5];

$title = trim(preg_replace('/^LIVE\s*STREAMING\s*HD/i', '', $rawTitle));

/* ================= IMAGE ================= */
$img = imagecreatefromjpeg($template);
$W = imagesx($img);
$H = imagesy($img);

/* ================= COLORS ================= */
$red   = imagecolorallocate($img, 220, 0, 0);
$white = imagecolorallocate($img, 255, 255, 255);
$shadow = imagecolorallocatealpha($img, 0, 0, 0, 80);

/* ================= HELPERS ================= */
function textWidth($text, $font, $size) {
    $b = imagettfbbox($size, 0, $font, $text);
    return $b[2] - $b[0];
}
function draw($img,$size,$x,$y,$color,$font,$text){
    global $shadow;
    imagettftext($img,$size,0,$x+3,$y+3,$shadow,$font,$text);
    imagettftext($img,$size,0,$x,$y,$color,$font,$text);
}

/* ================= HEADER ================= */
$hSize = 64;
$live = 'LIVE';
$rest = ' STREAMING NOW';
$x = ($W - (textWidth($live,$fontBold,$hSize)+textWidth($rest,$fontBold,$hSize))) / 2;

draw($img,$hSize,$x,180,$red,$fontBold,$live);
draw($img,$hSize,$x+textWidth($live,$fontBold,$hSize),180,$white,$fontBold,$rest);

/* ================= TITLE ================= */
$tSize = 90;
while (textWidth($title,$fontBold,$tSize) > $W-240) $tSize--;
draw($img,$tSize,($W-textWidth($title,$fontBold,$tSize))/2,315,$red,$fontBold,$title);

/* ================= SUB ================= */
draw($img,52,($W-textWidth($subTitle,$fontBold,52))/2,675,$red,$fontBold,$subTitle);
draw($img,44,($W-textWidth($location,$fontReg,44))/2,745,$white,$fontReg,$location);

draw($img,38,140,820,$red,$fontBold,$leftBot);
draw($img,38,$W-textWidth($rightBot,$fontBold,38)-140,820,$red,$fontBold,$rightBot);

draw($img,26,120,915,$white,$fontReg,$caption);

/* ================= OUTPUT ================= */
if ($mode === 'batch') {
    imagejpeg($img, $batchFile, 92);
} else {
    header('Content-Type: image/jpeg');
    imagejpeg($img);
}
imagedestroy($img);
