<?php
set_time_limit(0);
ini_set('memory_limit', '1024M');
ignore_user_abort(true);

// ================= CONFIG =================
$csvFile   = __DIR__ . '/data.csv';
$outputDir = __DIR__ . '/output/';
$bg        = __DIR__ . '/background.jpg';
$fontB     = __DIR__ . '/fonts/Roboto-Bold.ttf';
$fontR     = __DIR__ . '/fonts/Roboto-Regular.ttf';

$W = 1920;
$H = 1080;

// ================= CHECK =================
if (!file_exists($csvFile)) die('CSV NOT FOUND');
if (!file_exists($bg)) die('BACKGROUND NOT FOUND');
if (!is_dir($outputDir)) mkdir($outputDir, 0777, true);

// ================= READ CSV (FORCED) =================
$lines = file($csvFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$rows = [];

foreach ($lines as $line) {
    $row = str_getcsv($line, ',', '"');
    if (count($row) >= 6) {
        $rows[] = $row;
    }
}

echo "START GENERATE\n";
echo "TOTAL ROWS: " . count($rows) . "\n\n";

if (count($rows) === 0) {
    die("NO VALID ROWS\n");
}

// ================= TEXT HELPER =================
function drawText($img, $size, $y, $text, $font, $color, $shadow, $center = true) {
    $box = imagettfbbox($size, 0, $font, $text);
    $w = abs($box[2] - $box[0]);
    $x = $center ? (1920 - $w) / 2 : 100;

    imagettftext($img, $size, 0, $x+3, $y+3, $shadow, $font, $text);
    imagettftext($img, $size, 0, $x, $y, $color, $font, $text);
}

// ================= LOOP =================
$i = 1;
foreach ($rows as $r) {

    [$A,$B,$C,$D,$E,$F] = $r;

    $img = imagecreatefromjpeg($bg);
    imagealphablending($img,true);

    $red   = imagecolorallocate($img,220,0,0);
    $white = imagecolorallocate($img,255,255,255);
    $black = imagecolorallocate($img,0,0,0);

    // LIVE
    drawText($img, 42, 120, 'LIVE STREAMING NOW', $fontB, $white, $black);

    // TITLE AUTO SCALE
    $size = 90;
    do {
        $box = imagettfbbox($size,0,$fontB,$A);
        $w = abs($box[2]-$box[0]);
        if ($w > 1700) $size--;
    } while ($w > 1700 && $size > 46);

    drawText($img, $size, 250, $A, $fontB, $red, $black);

    // SUB
    drawText($img, 40, 340, $B, $fontB, $red, $black);

    // LOCATION
    drawText($img, 32, 390, $C, $fontR, $white, $black);

    // LEFT / RIGHT
    imagettftext($img, 30, 0, 120, 520, $red, $fontB, $E);
    $box = imagettfbbox(30,0,$fontB,$F);
    $x = 1920 - abs($box[2]-$box[0]) - 120;
    imagettftext($img, 30, 0, $x, 520, $red, $fontB, $F);

    // DESC
    drawText($img, 24, 1000, $D, $fontR, $white, $black);

    $file = $outputDir . $i . '.jpg';
    imagejpeg($img, $file, 92);
    imagedestroy($img);

    echo "✅ saved $i.jpg\n";
    $i++;
}

echo "\nDONE\n";
